/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.quest;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.toma.gunsrpg.common.quests.quest.QuestType;
import dev.toma.gunsrpg.common.quests.quest.SurvivalData;
import dev.toma.gunsrpg.common.quests.quest.area.IQuestAreaProvider;
import dev.toma.gunsrpg.common.quests.quest.area.QuestAreaScheme;
import dev.toma.gunsrpg.util.IIntervalProvider;
import dev.toma.gunsrpg.util.Interval;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.JSONUtils;

public class AreaSurvivalData
extends SurvivalData
implements IQuestAreaProvider {
    private final QuestAreaScheme areaScheme;

    public AreaSurvivalData(IIntervalProvider provider, QuestAreaScheme areaScheme) {
        super(provider);
        this.areaScheme = areaScheme;
    }

    @Override
    public QuestAreaScheme getAreaScheme() {
        return this.areaScheme;
    }

    @Override
    public String toString() {
        int ticks = this.getTicks();
        return String.format("Survival - Timer: [%s, (%d ticks)], Area: { %s }", Interval.format(ticks, f -> f.src(Interval.Unit.TICK).out(Interval.Unit.MINUTE, Interval.Unit.SECOND).compact()), ticks, this.areaScheme.toString());
    }

    public static final class Serializer
    implements QuestType.IQuestDataResolver<AreaSurvivalData> {
        @Override
        public AreaSurvivalData resolve(JsonElement element) throws JsonParseException {
            JsonObject object = JsonHelper.asJsonObject(element);
            String duration = JSONUtils.func_151200_h((JsonObject)object, (String)"duration");
            Interval provider = Interval.parse(duration);
            QuestAreaScheme areaScheme = QuestAreaScheme.fromJson(JSONUtils.func_152754_s((JsonObject)object, (String)"area"));
            return new AreaSurvivalData(provider, areaScheme);
        }

        @Override
        public CompoundNBT serialize(AreaSurvivalData data) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("ticks", data.getTicks());
            nbt.func_218657_a("area", (INBT)data.areaScheme.toNbt());
            return nbt;
        }

        @Override
        public AreaSurvivalData deserialize(CompoundNBT nbt) {
            int ticks = nbt.func_74762_e("ticks");
            QuestAreaScheme scheme = QuestAreaScheme.fromNbt(nbt.func_74775_l("area"));
            return new AreaSurvivalData(() -> ticks, scheme);
        }
    }
}

